function [combsubset] = select_unique_sets(tot_no_elem,no_unique_comb,no_elem_unique_comb)
%% input
% tot_no_elem : total number of elements to consider
% no_unique_comb: number of unique combinations needed
% no_elem_unique_comb : number of elements in each unique combination

%% output
% combsusbet : unique subsets of the form no_unique_comb x no_elem_unique_comb
combsubset=[];
while(size(combsubset,1)<no_unique_comb)
    combsubset=[combsubset;randperm(tot_no_elem,no_elem_unique_comb)];
    combsubset=unique(combsubset,'rows');
end
combsusbet=combsubset(1:no_unique_comb,:);
end

